unit Labdau;

interface
uses
Windows,Graphics,Forms;
type
  TLabda = class(TObject)
    // a labda objektum a TObject leszrmazottja
  private
    // a pozci bels trolsa
    FPos:TPoint;
    // a pozci olvassa s rsa
    procedure SetPos(Pos:TPoint);
    function GetPos:TPoint;
  public
    //a labdt megjelent bitkp
    Labda:TBitmap;
    //A szl
    Parent:TForm;
    //a labda sebessge
    dx,dy:integer;
    // a labda mrete
    meret:integer;
    constructor Create(Par:TForm; szin:TColor);
  published
    //a labda pozcija
    Property Pos:TPoint read GetPos write SetPos;
    procedure Kirajz;
end;

implementation
constructor TLabda.Create(Par:TForm; szin:TColor);
 var seged:TBitmap;
 begin
    // a labda mrete
    meret:=60;
    // a mozgats sebessge
    dx:=10;
    dy:=10;
    // a szl megadsa
    Parent:=Par;
    //megrajzoljuk a labda bittrkpet (seged)
    seged:=TBitMap.Create;
    seged.Height:=meret;
    seged.Width:=meret;
    with seged.Canvas do
     begin
       Brush.Color:=szin;
       Pen.Color:=szin;
       Ellipse(0,0,meret,meret);
       Brush.Color:=clWhite;
       Pen.Color:=clWhite;
       Ellipse(1*meret div 12,2*meret div 12,4*meret div 12,5*meret div 12);
       Ellipse(7*meret div 12,2*meret div 12,10*meret div 12,5*meret div 12);
       Ellipse(2*meret div 12,10*meret div 12,5*meret div 12,7*meret div 12);
       Ellipse(8*meret div 12,10*meret div 12,11*meret div 12,7*meret div 12);
     end;
    //a megrajzolt bittrkp (seged) inverze lesz a labda
    Labda:=TBitMap.Create;
    Labda.Height:=meret;
    Labda.Width:=meret;
    with Labda.Canvas do
     begin
       Brush.Color:=Parent.Color;
       Pen.Color:=Parent.Color;
       Ellipse(0,0,meret,meret);
       CopyMode:=cmSrcInvert;
       Draw(0,0,seged);
     end;
    seged.free;
 end;
procedure TLabda.SetPos(Pos:TPoint);
  begin
     // ha a pozci vltozik a rgi pozciba a labdt
     Kirajz;
     // a pozci vltozsa utn az j pozciba a labdt
     FPos.x:=Pos.x;
     FPos.y:=Pos.y;
     Kirajz;
  end;
function TLabda.GetPos:TPoint;
  begin
     // a pozci olvassa
     result:=FPos;
  end;
procedure TLabda.Kirajz;
  begin
     // a kpernyre helyezi a labdt inverz mdon
     Parent.Canvas.Copymode:=cmSrcInvert;
     Parent.Canvas.Draw(pos.x,pos.y,Labda);
  end;
end.
